(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     32520,        988]
NotebookOptionsPosition[     29496,        897]
NotebookOutlinePosition[     29938,        915]
CellTagsIndexPosition[     29895,        912]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Maksutov-Cassegrain Telescope", "Title"],

Cell[CellGroupData[{

Cell["Main function", "Subsection"],

Cell[TextData[StyleBox["MaksutovCassegrain",
 FontWeight->"Bold",
 FontVariations->{"Underline"->True}]], "Text"],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Input variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["f1",
           FontWeight->Bold], Cell["focal length of the primary mirror"]},
         {Cell["ft",
           FontWeight->Bold], Cell["total focal length"]},
         {Cell["em",
           FontWeight->Bold], Cell["back distance"]},
         {Cell["\[Delta]",
           FontWeight->Bold], Cell[
          "fraction of distance corrector-primary in focal unity"]},
         {Cell["diam",
           FontWeight->Bold], Cell["diameter of the primary mirror"]},
         {Cell["\[Theta]",
           FontWeight->Bold], Cell["field angle in degrees"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Optional arguments\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["OutputType", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], "\[SpanFromLeft]"},
         {"\[SpanFromAbove]", Cell["Report"], Cell["\<\
generates a report as a new notebook, that can be saved in many formats, for \
instance PDF\
\>"]},
         {"\[SpanFromAbove]", Cell["Print"], Cell["\<\
prints results in the current position of the evaluating notebook\
\>"]},
         {"\[SpanFromAbove]", Cell["Basic"], Cell["\<\
returns the list of pairs, with the short description of the output and the \
corresponding value\
\>"]},
         {"\[SpanFromAbove]", Cell["Values"], Cell[
          "returns only the list of output values, no descriptions"]},
         {Cell["OutputLevel", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], Cell[""]},
         {"\[SpanFromAbove]", Cell["Full"], Cell[
          "gives both input parameters and output values"]},
         {"\[SpanFromAbove]", Cell["Minimal"], Cell[
          "gives only output values"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Interface function", "Subsection"],

Cell[TextData[{
 StyleBox["MaksutovCassegrainInputPanel",
  FontWeight->"Bold",
  FontVariations->{"Underline"->True}],
 " (no argument required, it creates a panel to work with the main function \
by means of easy controls and input fields)"
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Auxiliary function", "Subsection"],

Cell[TextData[StyleBox["TotalAberrations",
 FontWeight->"Bold",
 FontVariations->{"Underline"->True}]], "Text"],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Input variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["rad",
           FontWeight->Bold], Cell["list of the radii of the surfaces"]},
         {Cell["thick",
           FontWeight->Bold], Cell["\<\
list of the distances between the surfaces along the optical axis\
\>"]},
         {Cell["ind",
           FontWeight->Bold], Cell["list of the refractive indices"]},
         {Cell["costasf",
           FontWeight->Bold], 
          TagBox[GridBox[{
             {"\<\"list of the constants which characterize the nature of any \
surface\"\>"},
             {"\<\"(0 for a sphere, K for a conic, {a4, as} for an aspheric \
surface)\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"]},
         {Cell["stoprad",
           FontWeight->Bold], Cell["radius of the aperture stop"]},
         {Cell["nstop",
           FontWeight->Bold], Cell["number of the surfaces before the stop"]},
         {Cell["dis",
           FontWeight->Bold], 
          TagBox[GridBox[{
             {"\<\"if nstop = 0, is the (negative) distance of the aperture \
stop from the first surface after it\"\>"},
             {"\<\"if nstop > 0,  is the distance between the last surface \
before the aperture stop and the aperture stop\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"]},
         {Cell["dobject",
           FontWeight->Bold], Cell[
          "distance of the object from the first surface"]},
         {Cell["hobject",
           FontWeight->Bold], Cell["\<\
height of the object (only if the object is at a finite distance)\
\>"]},
         {Cell["angle",
           FontWeight->Bold], Cell[
          "view angle in degrees (if the object is at infinity)"]},
         {Cell["waves",
           FontWeight->Bold], Cell[
          "the wavelengths of the chosen refractive indices"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Optional arguments\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["OutputType", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], "\[SpanFromLeft]"},
         {"\[SpanFromAbove]", Cell["Report"], Cell["\<\
generates a report as a new notebook, that can be saved in many formats, for \
instance PDF\
\>"]},
         {"\[SpanFromAbove]", Cell["Print"], Cell["\<\
prints results in the current position of the evaluating notebook\
\>"]},
         {"\[SpanFromAbove]", Cell["Basic"], Cell["\<\
returns the list of pairs, with the short description of the output and the \
corresponding value\
\>"]},
         {"\[SpanFromAbove]", Cell["Values"], Cell[
          "returns only the list of output values, no descriptions"]},
         {Cell["OutputLevel", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], Cell[""]},
         {"\[SpanFromAbove]", Cell["Full"], Cell[
          "gives both input parameters and output values"]},
         {"\[SpanFromAbove]", Cell["Minimal"], Cell[
          "gives only output values"]},
         {"\[SpanFromAbove]", Cell["Coefficients"], Cell[
          "gives only aberration coefficients"]},
         {"\[SpanFromAbove]", Cell["None"], Cell["doesn't show any result"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Output variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["GOn",
           FontWeight->Bold], Cell["Number of surface"]},
         {Cell["GOren",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Radius of the entrance pupil for \"",SubscriptBox[
            "\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOwen",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Distance of the exit pupil from the last surface for \"",
            SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOrexit",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Radius of the exit pupil for \"",SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOdistancefp",
           FontWeight->Bold], Cell[
          "Distance of the first principal plane from the first surface"]},
         {Cell["GOdistancesp",
           FontWeight->Bold], Cell[
          "Distance of the second principal plane from the last surface"]},
         {Cell["GOdistancegauss",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Gaussian distance of the images from the surface for \"",
            SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOfocalLength",
           FontWeight->Bold], Cell["Focal length"]},
         {Cell["GOimageHeight",
           FontWeight->Bold], Cell["Image height"]},
         {Cell["GOaberration",
           FontWeight->Bold], Cell["Third-order spherical aberration "]},
         {Cell["GOcoma",
           FontWeight->Bold], Cell["Third-order coma"]},
         {Cell["GOastigmatism",
           FontWeight->Bold], Cell["Third-order astigmatism"]},
         {Cell["GOcurvature",
           FontWeight->Bold], Cell["Third-order total curvature"]},
         {Cell["GOSeidelCurvature",
           FontWeight->Bold], Cell["Third-order curvature coefficient"]},
         {Cell["GOPetzvalRadius",
           FontWeight->Bold], Cell["Petzval radius"]},
         {Cell["GOdistortion",
           FontWeight->Bold], Cell["Third-order distortion"]},
         {Cell["GOSphericalCoefficient",
           FontWeight->Bold], Cell["Spherical Coefficient"]},
         {Cell["GOComaCoefficient",
           FontWeight->Bold], Cell["Coma Coefficient"]},
         {Cell["GOAstigmatismCoefficient",
           FontWeight->Bold], Cell["Astigmatism Coefficient"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Design of a Maksutov-Cassegrain telescope", "Title"],

Cell[TextData[{
 "A Maksutov-Cassegrain telescope is obtained by placing a meniscus ",
 Cell[BoxData[
  FormBox[
   RowBox[{"M", " "}], TraditionalForm]]],
 "in front of a Cassegrain combination of two spherical mirrors ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["S", "1"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["S", "2"], TraditionalForm]]],
 ".  \nThe starting data are the same of a Cassegrain combination, i. e."
}], "Text"],

Cell[BoxData[{
 RowBox[{"f1", " ", "=", "  ", "primary"}], "\n", 
 RowBox[{"ft", " ", "=", " ", 
  RowBox[{"total", " ", "focal", " ", "length"}]}], "\n", 
 RowBox[{"em", " ", "=", " ", 
  RowBox[{"back", " ", "distance"}]}]}], "DisplayFormula"],

Cell["From them, the following quantities can be determined", "Text"],

Cell[BoxData[{
 RowBox[{"\[Alpha]", " ", "=", " ", 
  FractionBox["em", "f1"]}], "\n", 
 RowBox[{"M", " ", "=", " ", 
  FractionBox["ft", "f1"]}], "\[IndentingNewLine]", 
 RowBox[{"co", " ", "=", " ", 
  RowBox[{"1", " ", "-", " ", "\[Beta]"}]}], "\[IndentingNewLine]", 
 RowBox[{"\[Gamma]", " ", "=", " ", 
  FractionBox[
   RowBox[{"2", "M", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Alpha]"}], ")"}]}], 
   RowBox[{"1", "-", 
    SuperscriptBox["M", "2"]}]]}]}], "DisplayFormula"],

Cell["\<\
Then, \[Alpha] and M are taken as fundamental variables and the following \
quantities are introduced\
\>", "Text"],

Cell[BoxData[{
 RowBox[{"R1", " ", "=", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], "f1"}], " ", "=", " ", 
   RowBox[{"primary", " ", "radius"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"R2", " ", "=", " ", 
  RowBox[{
   RowBox[{"\[Gamma]", " ", "f1"}], " ", "=", " ", 
   RowBox[{"secondary", " ", "radius", " ", 
    RowBox[{"(", 
     RowBox[{"\[Gamma]", "<", "0"}], ")"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{"s12", " ", "=", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "\[Beta]"}], " ", "f1"}], " ", "=", " ", 
   RowBox[{
   "distance", " ", "of", " ", "the", " ", "secondary", " ", "from", " ", 
    "the", " ", "primary", " ", 
    RowBox[{"(", 
     RowBox[{"\[Beta]", ">", "0"}], ")"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{"K", " ", "=", " ", 
  RowBox[{
  "conic", " ", "constant", " ", "of", " ", 
   "secondary"}]}]}], "DisplayFormula"],

Cell["\<\
The spherical aberration coefficient of the Cassegrain combination are (the \
variable f1, \[Beta], \[Gamma], M, \[Alpha], \[Delta], x, \[Theta], \[Lambda] \
have to be unassigned, for that we use Clear)\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "f1", ",", "\[Beta]", ",", "\[Gamma]", ",", "M", ",", "\[Alpha]", ",", 
    "\[Delta]", ",", "x", ",", "\[Theta]", ",", "\[Lambda]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Beta]", "=", 
   FractionBox[
    RowBox[{"M", "-", "\[Alpha]"}], 
    RowBox[{"M", "+", "1"}]]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Gamma]", "=", 
   FractionBox[
    RowBox[{"2", "M", 
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Alpha]"}], ")"}]}], 
    RowBox[{"1", "-", 
     SuperscriptBox["M", "2"]}]]}], ";"}], "\n", 
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], "f1"}], ",", 
     RowBox[{"\[Gamma]", " ", "f1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "\[Beta]"}], " ", "f1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}], ",", "1"}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", "D", ",", "0", ",", 
   RowBox[{
    RowBox[{"-", "\[Delta]"}], " ", "f1"}], ",", 
   RowBox[{"-", "Infinity"}], ",", "x", ",", "\[Theta]", ",", 
   RowBox[{"{", "\[Lambda]", "}"}]}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"DS1", "=", 
  RowBox[{"Simplify", "[", "GOSphericalCoefficient", "]"}]}]], "Input"],

Cell["The spherical aberration coefficient of the corrector", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "R1", ",", "s", ",", "\[CapitalDelta]", ",", "GON", ",", "x", ",", 
    "\[Theta]", ",", "\[Lambda]"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TotalAberrations", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"R1", ",", 
      RowBox[{"R1", "-", "s"}]}], "}"}], ",", 
    RowBox[{"{", "\[CapitalDelta]", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "GON", ",", "1"}], "}"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", "D", ",", "0", ",", "0", ",", 
    RowBox[{"-", "Infinity"}], ",", "x", ",", "\[Theta]", ",", 
    RowBox[{"{", "\[Lambda]", "}"}]}], "]"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"DM1", "=", 
  RowBox[{"Simplify", "[", "GOSphericalCoefficient", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"where", " ", "the", " ", "difference", " ", 
  FormBox[
   RowBox[{"s", "=", 
    RowBox[{
     SubscriptBox["R", "1"], "-", 
     SubscriptBox["R", "2"]}]}],
   TraditionalForm], " ", "is", " ", "defined", " ", "by", " ", "the", " ", 
  "relation"}]], "Text",
 FontFamily->"Times New Roman",
 FontSize->18],

Cell[BoxData[
 FormBox[
  RowBox[{"s", "=", 
   RowBox[{"\[CapitalDelta]", " ", 
    FractionBox[
     RowBox[{
      SuperscriptBox["N", "2"], "-", "1"}], 
     RowBox[{"0.97", 
      SuperscriptBox["N", "2"]}]]}]}], TraditionalForm]], "DisplayFormula",
 FontFamily->"Times New Roman",
 FontSize->18],

Cell[BoxData[
 RowBox[{
  RowBox[{"obtained", " ", "to", " ", "reduce", " ", "the", " ", 
   RowBox[{"chromatism", ".", " ", "Therefore"}]}], ",", 
  RowBox[{"we", " ", "have"}]}]], "Text",
 FontFamily->"Times New Roman",
 FontSize->18],

Cell[BoxData[
 RowBox[{
  RowBox[{"DM1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{"GOSphericalCoefficient", "/.", 
     RowBox[{"s", "\[Rule]", 
      RowBox[{"\[CapitalDelta]", 
       FractionBox[
        RowBox[{
         SuperscriptBox["GON", "2"], "-", "1"}], 
        RowBox[{"0.97", 
         SuperscriptBox["GON", "2"]}]]}]}]}], "]"}]}], 
  "\[IndentingNewLine]"}]], "Input"],

Cell["\<\
Therefore, the relation, which approximatively expresses the absence of \
spherical aberration, is\
\>", "Text",
 FontSize->18],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["DM", "1"], "+", 
    SubscriptBox["DS", "1"]}], "=", "0."}], 
  TraditionalForm]], "DisplayFormula"],

Cell["\<\
In nondimensional form we evaluate R1 in terms of f1 and \[CapitalDelta] in \
terms of the diameter D of M.\
\>", "Text",
 FontFamily->"Times New Roman",
 FontSize->18],

Cell["For instance, we have :", "Text",
 FontFamily->"Times New Roman",
 FontSize->18],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sfr", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"DM1", "+", "DS1"}], ")"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"f1", "\[Rule]", "1"}], ",", 
        RowBox[{"M", "\[Rule]", "4"}], ",", 
        RowBox[{"\[Alpha]", "\[Rule]", "0.4"}], ",", 
        RowBox[{"\[CapitalDelta]", "\[Rule]", 
         RowBox[{"0.1", "A"}]}], ",", 
        RowBox[{"s", "\[Rule]", 
         RowBox[{"0.1", "A", 
          FractionBox[
           RowBox[{
            SuperscriptBox["GON", "2"], "-", "1"}], 
           RowBox[{"0.97", 
            SuperscriptBox["GON", "2"]}]]}]}]}], "}"}]}], ")"}], "/.", 
    RowBox[{"GON", "\[Rule]", "1.5187228"}]}]}], ";"}], "\n", 
 RowBox[{"eq1", "=", 
  RowBox[{
   RowBox[{"Numerator", "[", 
    RowBox[{"Together", "[", "sfr", "]"}], "]"}], "\[Equal]", 
   "0"}]}]}], "Input"],

Cell[TextData[{
 "This algebraic seventh-degree equation, for any value of the aperture ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]]],
 ", admits seven roots. For instance, for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"A", "=", "4"}], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"A", "=", "3"}], TraditionalForm]]],
 ", we respectively have:"
}], "Text",
 FontSize->18],

Cell[BoxData[{
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"eq1", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "/.", 
      RowBox[{"A", "\[Rule]", "4"}]}], ")"}], "\[Equal]", "0"}], ",", "R1"}], 
  "]"}], "\n", 
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"eq1", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "/.", 
      RowBox[{"A", "\[Rule]", "3"}]}], ")"}], "\[Equal]", "0"}], ",", "R1"}], 
  "]"}]}], "Input"],

Cell[TextData[{
 "In any case, four roots are complex, one corresponds to a very low value of \
",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "1"], TraditionalForm]]],
 " and the last two ones are acceptable. We choose the negative root."
}], "Text",
 FontSize->18],

Cell["\<\
REMARK. The following program is based on the above analysis. The \
corresponding results can not be accepted since \
\>", "Text",
 FontSize->18],

Cell["\<\
the finite negative focal of the corrector leads to a total focal length \
which is much higher than the wished focal length;\
\>", "Item",
 FontSize->18],

Cell["\<\
the strong curvatures of M introduces  higher-order spherical aberration.\
\>", "Item",
 FontSize->18],

Cell["To reach acceptable results, we must ", "Text",
 FontSize->18],

Cell["\<\
introduce as input data a total focal length less that the expected focal;\
\>", "Item",
 FontSize->18],

Cell["\<\
reduce the radius of the second surface of M until the third-order and \
fifth-order spherical aberrations balance each the other.\
\>", "Item",
 FontSize->18]
}, Open  ]],

Cell[CellGroupData[{

Cell["MaksutovCassegrain Examples", "Title"],

Cell["\<\
To use the MaksutovCassegrain function you can either use directly the \
function MaksutovCassegrain[f1, em, ft, \[Delta], diam, \[Theta]] or use the \
interactive panel created by calling the function \
MaksutovCassegrainInputPanel[]. It let\[CloseCurlyQuote]s you to set input \
values and then call the MaksutovCassegrain function. Moreover, it helps to \
load examples from the saved archives and set the output style.
Here are some examples\
\>", "Text"],

Cell["\<\
Maksutov Cassegrain, focal length 2800, principal mirror f/3.5 \
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f1", "=", "700"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"em", "=", "200"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ft", "=", "2400"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Delta]", "=", 
   RowBox[{"520", "/", "700"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"diam", " ", "=", "200"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]", " ", "=", "0.25"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "this", " ", "generates", " ", "a", " ", "new", " ", "notebook", " ", 
    "with", " ", "a", " ", "report", " ", "of", " ", 
    RowBox[{"input", "/", "output"}], " ", "values"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"MaksutovCassegrain", "[", 
   RowBox[{
   "f1", ",", "ft", ",", "em", ",", " ", "\[Delta]", ",", "diam", ",", 
    "\[Theta]"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "this", " ", "prints", " ", "a", " ", "table", " ", "with", " ", "the", 
    " ", "summary", " ", "of", " ", 
    RowBox[{"input", "/", "output"}], " ", "values"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"MaksutovCassegrain", "[", 
   RowBox[{
   "f1", ",", "ft", ",", "em", ",", " ", "\[Delta]", ",", "diam", ",", 
    "\[Theta]", ",", " ", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Print\>\""}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "this", " ", "prints", " ", "a", " ", "table", " ", "with", " ", "only", 
    " ", "the", " ", "output", " ", "values"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"MaksutovCassegrain", "[", 
   RowBox[{
   "f1", ",", "ft", ",", "em", ",", " ", "\[Delta]", ",", "diam", ",", 
    "\[Theta]", ",", " ", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Print\>\""}], ",", " ", 
    RowBox[{"OutputLevel", "\[Rule]", "\"\<Minimal\>\""}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"this", " ", "gives", " ", 
     RowBox[{"input", "/", "output"}], " ", "values", " ", "as", " ", "a", 
     " ", "Return", " ", "from", " ", "the", " ", "function"}], ",", " ", 
    RowBox[{
    "with", " ", "labels", " ", "for", " ", "each", " ", "variable"}]}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"MaksutovCassegrain", "[", 
   RowBox[{
   "f1", ",", "ft", ",", "em", ",", " ", "\[Delta]", ",", "diam", ",", 
    "\[Theta]", ",", " ", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Basic\>\""}], ",", " ", 
    RowBox[{"OutputLevel", "\[Rule]", "\"\<Full\>\""}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "this", " ", "gives", " ", "only", " ", "output", " ", "values", " ", 
     "as", " ", "a", " ", "Return", " ", "from", " ", "the", " ", 
     "function"}], ",", " ", 
    RowBox[{"with", " ", "no", " ", "labels", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"useful", " ", "for", " ", "cutting"}], "&"}], "pasting", " ",
        "operations"}], " "}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"MaksutovCassegrain", "[", 
   RowBox[{
   "f1", ",", "ft", ",", "em", ",", " ", "\[Delta]", ",", "diam", ",", 
    "\[Theta]", ",", " ", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Values\>\""}], ",", " ", 
    RowBox[{"OutputLevel", "\[Rule]", "\"\<Minimal\>\""}]}], "]"}]}]], "Input"],

Cell["\<\
Maksutov Cassegrain, focal length 2200, principal mirror f/3 \
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f1", "=", "600"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"em", "=", "200"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ft", "=", "1950"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Delta]", "=", 
   RowBox[{"450", "/", "600"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"diam", "=", "200"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Theta]", "=", "0.5"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"MaksutovCassegrain", "[", 
  RowBox[{
  "f1", ",", "ft", ",", "em", ",", " ", "\[Delta]", ",", "diam", ",", 
   "\[Theta]"}], "]"}]], "Input"],

Cell["A convenient value of the second radius is -280.72", "Text"],

Cell["Maksutov Cassegrain, focal length 800, principal mirror f/3", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f1", "=", "280"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"em", "=", "40"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ft", "=", "760"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Delta]", "=", 
   RowBox[{"217", "/", "280"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"diam", " ", "=", "90"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]", " ", "=", "1"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"MaksutovCassegrain", "[", 
  RowBox[{
  "f1", ",", "ft", ",", "em", ",", " ", "\[Delta]", ",", "diam", ",", 
   "\[Theta]"}], "]"}]], "Input"],

Cell["Load examples from the archive using LoadExample ", "Text"],

Cell[BoxData[
 RowBox[{"LoadExample", "[", "\"\<MaksutovCassegrain\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"MaksutovCassegrain", "[", "]"}]], "Input"],

Cell["Use the GUI panel to have all parameters under control", "Text"],

Cell[BoxData[
 RowBox[{"MaksutovCassegrainInputPanel", "[", "]"}]], "Input"]
}, Open  ]]
},
WindowSize->{1920, 992},
WindowMargins->{{-8, Automatic}, {Automatic, -8}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
TrackCellChangeTimes->False,
FrontEndVersion->"11.0 for Microsoft Windows (64-bit) (July 28, 2016)",
StyleDefinitions->"GeometricOptics.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 46, 0, 71, "Title"],
Cell[CellGroupData[{
Cell[650, 26, 35, 0, 43, "Subsection"],
Cell[688, 28, 113, 2, 46, "Text"],
Cell[804, 32, 1627, 43, 303, "Text"],
Cell[2434, 77, 2110, 53, 389, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4581, 135, 40, 0, 43, "Subsection"],
Cell[4624, 137, 254, 6, 46, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4915, 148, 40, 0, 43, "Subsection"],
Cell[4958, 150, 111, 2, 46, "Text"],
Cell[5072, 154, 3193, 83, 551, "Text"],
Cell[8268, 239, 2296, 56, 473, "Text"],
Cell[10567, 297, 3465, 89, 849, "Text"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14081, 392, 58, 0, 71, "Title"],
Cell[14142, 394, 464, 14, 70, "Text"],
Cell[14609, 410, 245, 5, 70, "DisplayFormula"],
Cell[14857, 417, 69, 0, 46, "Text"],
Cell[14929, 419, 486, 13, 141, "DisplayFormula"],
Cell[15418, 434, 125, 3, 46, "Text"],
Cell[15546, 439, 865, 24, 92, "DisplayFormula"],
Cell[16414, 465, 227, 4, 46, "Text"],
Cell[16644, 471, 1240, 39, 135, "Input"],
Cell[17887, 512, 107, 2, 32, "Input"],
Cell[17997, 516, 69, 0, 46, "Text"],
Cell[18069, 518, 722, 19, 55, "Input"],
Cell[18794, 539, 107, 2, 32, "Input"],
Cell[18904, 543, 331, 10, 45, "Text"],
Cell[19238, 555, 301, 10, 55, "DisplayFormula"],
Cell[19542, 567, 236, 6, 45, "Text"],
Cell[19781, 575, 389, 12, 78, "Input"],
Cell[20173, 589, 137, 4, 46, "Text"],
Cell[20313, 595, 165, 6, 24, "DisplayFormula"],
Cell[20481, 603, 178, 5, 45, "Text"],
Cell[20662, 610, 86, 2, 45, "Text"],
Cell[20751, 614, 899, 27, 78, "Input"],
Cell[21653, 643, 397, 14, 46, "Text"],
Cell[22053, 659, 514, 18, 55, "Input"],
Cell[22570, 679, 269, 8, 46, "Text"],
Cell[22842, 689, 155, 4, 46, "Text"],
Cell[23000, 695, 164, 4, 26, "Item"],
Cell[23167, 701, 112, 3, 26, "Item"],
Cell[23282, 706, 68, 1, 46, "Text"],
Cell[23353, 709, 113, 3, 26, "Item"],
Cell[23469, 714, 169, 4, 26, "Item"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23675, 723, 44, 0, 71, "Title"],
Cell[23722, 725, 469, 8, 94, "Text"],
Cell[24194, 735, 87, 2, 46, "Text"],
Cell[24284, 739, 445, 13, 143, "Input"],
Cell[24732, 754, 439, 11, 55, "Input"],
Cell[25174, 767, 491, 12, 55, "Input"],
Cell[25668, 781, 518, 12, 55, "Input"],
Cell[26189, 795, 668, 15, 55, "Input"],
Cell[26860, 812, 787, 19, 55, "Input"],
Cell[27650, 833, 85, 2, 46, "Text"],
Cell[27738, 837, 434, 13, 143, "Input"],
Cell[28175, 852, 166, 4, 32, "Input"],
Cell[28344, 858, 66, 0, 46, "Text"],
Cell[28413, 860, 75, 0, 46, "Text"],
Cell[28491, 862, 439, 13, 143, "Input"],
Cell[28933, 877, 166, 4, 32, "Input"],
Cell[29102, 883, 65, 0, 46, "Text"],
Cell[29170, 885, 89, 1, 32, "Input"],
Cell[29262, 888, 66, 1, 32, "Input"],
Cell[29331, 891, 70, 0, 46, "Text"],
Cell[29404, 893, 76, 1, 32, "Input"]
}, Open  ]]
}
]
*)

